export declare class AuthApiBase {
    authToken: string;
    protected constructor();
    getBaseUrl(defaultUrl: string, baseUrl: string): string;
    setAuthToken(token: string): void;
    protected transformOptions(options: any): Promise<any>;
}
export declare class PageBuilderClient extends AuthApiBase {
    private http;
    private baseUrl;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined;
    constructor(baseUrl?: string, http?: {
        fetch(url: RequestInfo, init?: RequestInit): Promise<Response>;
    });
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @param path (optional)
     * @param type (optional)
     * @param draft (optional)
     * @return OK
     */
    getTemplate(storeId?: string | undefined, theme?: string | undefined, path?: string | undefined, type?: string | undefined, draft?: boolean | undefined): Promise<void>;
    protected processGetTemplate(response: Response): Promise<void>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @return OK
     */
    getSettings(storeId?: string | undefined, theme?: string | undefined): Promise<void>;
    protected processGetSettings(response: Response): Promise<void>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @return OK
     */
    getTemplates(storeId?: string | undefined, theme?: string | undefined): Promise<void>;
    protected processGetTemplates(response: Response): Promise<void>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @return OK
     */
    getObjects(storeId?: string | undefined, theme?: string | undefined): Promise<void>;
    protected processGetObjects(response: Response): Promise<void>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @return OK
     */
    getSectionsSettings(storeId?: string | undefined, theme?: string | undefined): Promise<void>;
    protected processGetSectionsSettings(response: Response): Promise<void>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @param type (optional)
     * @param folder (optional)
     * @param pattern (optional)
     * @param keyword (optional)
     * @return OK
     */
    search(storeId?: string | undefined, theme?: string | undefined, type?: string | undefined, folder?: string | undefined, pattern?: string | undefined, keyword?: string | undefined): Promise<string>;
    protected processSearch(response: Response): Promise<string>;
    /**
     * @param storeId (optional)
     * @param theme (optional)
     * @param draft (optional)
     * @param body (optional)
     * @return OK
     */
    saveTemplates(storeId?: string | undefined, theme?: string | undefined, draft?: boolean | undefined, body?: SaveFilesModel | undefined): Promise<void>;
    protected processSaveTemplates(response: Response): Promise<void>;
}
export declare class PageBuilderPageClient extends AuthApiBase {
    private http;
    private baseUrl;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined;
    constructor(baseUrl?: string, http?: {
        fetch(url: RequestInfo, init?: RequestInit): Promise<Response>;
    });
    /**
     * @param body (optional)
     * @return OK
     */
    searchGroups(body?: PageBuilderPageSearchCriteria | undefined): Promise<GroupedPageBuilderPageSearchResult>;
    protected processSearchGroups(response: Response): Promise<GroupedPageBuilderPageSearchResult>;
    /**
     * @param responseGroup (optional)
     * @return OK
     */
    getGroup(groupId: string, responseGroup?: string | undefined): Promise<GroupedPageBuilderPage>;
    protected processGetGroup(response: Response): Promise<GroupedPageBuilderPage>;
    /**
     * @return OK
     */
    deleteGroup(groupId: string): Promise<void>;
    protected processDeleteGroup(response: Response): Promise<void>;
    /**
     * @param body (optional)
     * @return OK
     */
    updateGroup(body?: GroupedPageBuilderPage | undefined): Promise<GroupedPageBuilderPage>;
    protected processUpdateGroup(response: Response): Promise<GroupedPageBuilderPage>;
    /**
     * @param body (optional)
     * @return OK
     */
    createGroup(body?: GroupedPageBuilderPage | undefined): Promise<GroupedPageBuilderPage>;
    protected processCreateGroup(response: Response): Promise<GroupedPageBuilderPage>;
    /**
     * @param ids (optional)
     * @return No Content
     */
    archiveGroups(ids?: string[] | undefined): Promise<void>;
    protected processArchiveGroups(response: Response): Promise<void>;
    /**
     * @param publish (optional)
     * @return OK
     */
    publishGroup(groupId: string, publish?: boolean | undefined): Promise<void>;
    protected processPublishGroup(response: Response): Promise<void>;
    /**
     * @return OK
     */
    publishStatus(groupId: string): Promise<FilePublishStatus>;
    protected processPublishStatus(response: Response): Promise<FilePublishStatus>;
    /**
     * @param storeId (optional)
     * @return OK
     */
    getAvailableLanguages(storeId?: string | undefined): Promise<string[]>;
    protected processGetAvailableLanguages(response: Response): Promise<string[]>;
    /**
     * @return OK
     */
    getUserGroups(): Promise<string[]>;
    protected processGetUserGroups(response: Response): Promise<string[]>;
    /**
     * @param body (optional)
     * @return OK
     */
    getOrganizations(body?: MembersSearchCriteria | undefined): Promise<MemberSearchResult>;
    protected processGetOrganizations(response: Response): Promise<MemberSearchResult>;
    /**
     * @param idQuery (optional)
     * @return OK
     */
    getOrganization(idPath: string, idQuery?: string | undefined): Promise<Member>;
    protected processGetOrganization(response: Response): Promise<Member>;
    /**
     * @param draft (optional)
     * @return OK
     */
    getPageContent(groupId: string, draft?: boolean | undefined): Promise<void>;
    protected processGetPageContent(response: Response): Promise<void>;
    /**
     * @return OK
     */
    savePageContent(groupId: string): Promise<void>;
    protected processSavePageContent(response: Response): Promise<void>;
}
export declare enum AddressType {
    Undefined = "Undefined",
    Billing = "Billing",
    Shipping = "Shipping",
    BillingAndShipping = "BillingAndShipping",
    Pickup = "Pickup"
}
export declare class CustomerAddress implements ICustomerAddress {
    addressType?: CustomerAddressAddressType;
    key?: string | undefined;
    name?: string | undefined;
    organization?: string | undefined;
    countryCode?: string | undefined;
    countryName?: string | undefined;
    city?: string | undefined;
    postalCode?: string | undefined;
    zip?: string | undefined;
    line1?: string | undefined;
    line2?: string | undefined;
    regionId?: string | undefined;
    regionName?: string | undefined;
    firstName?: string | undefined;
    middleName?: string | undefined;
    lastName?: string | undefined;
    phone?: string | undefined;
    email?: string | undefined;
    outerId?: string | undefined;
    isDefault?: boolean;
    description?: string | undefined;
    constructor(data?: ICustomerAddress);
    init(_data?: any): void;
    static fromJS(data: any): CustomerAddress;
    toJSON(data?: any): any;
}
export interface ICustomerAddress {
    addressType?: CustomerAddressAddressType;
    key?: string | undefined;
    name?: string | undefined;
    organization?: string | undefined;
    countryCode?: string | undefined;
    countryName?: string | undefined;
    city?: string | undefined;
    postalCode?: string | undefined;
    zip?: string | undefined;
    line1?: string | undefined;
    line2?: string | undefined;
    regionId?: string | undefined;
    regionName?: string | undefined;
    firstName?: string | undefined;
    middleName?: string | undefined;
    lastName?: string | undefined;
    phone?: string | undefined;
    email?: string | undefined;
    outerId?: string | undefined;
    isDefault?: boolean;
    description?: string | undefined;
}
export declare class DynamicObjectProperty implements IDynamicObjectProperty {
    objectId?: string | undefined;
    values?: DynamicPropertyObjectValue[] | undefined;
    name?: string | undefined;
    description?: string | undefined;
    objectType?: string | undefined;
    isArray?: boolean;
    isDictionary?: boolean;
    isMultilingual?: boolean;
    isRequired?: boolean;
    displayOrder?: number | undefined;
    valueType?: DynamicObjectPropertyValueType;
    displayNames?: DynamicPropertyName[] | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: IDynamicObjectProperty);
    init(_data?: any): void;
    static fromJS(data: any): DynamicObjectProperty;
    toJSON(data?: any): any;
}
export interface IDynamicObjectProperty {
    objectId?: string | undefined;
    values?: DynamicPropertyObjectValue[] | undefined;
    name?: string | undefined;
    description?: string | undefined;
    objectType?: string | undefined;
    isArray?: boolean;
    isDictionary?: boolean;
    isMultilingual?: boolean;
    isRequired?: boolean;
    displayOrder?: number | undefined;
    valueType?: DynamicObjectPropertyValueType;
    displayNames?: DynamicPropertyName[] | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare class DynamicPropertyName implements IDynamicPropertyName {
    locale?: string | undefined;
    name?: string | undefined;
    constructor(data?: IDynamicPropertyName);
    init(_data?: any): void;
    static fromJS(data: any): DynamicPropertyName;
    toJSON(data?: any): any;
}
export interface IDynamicPropertyName {
    locale?: string | undefined;
    name?: string | undefined;
}
export declare class DynamicPropertyObjectValue implements IDynamicPropertyObjectValue {
    objectType?: string | undefined;
    objectId?: string | undefined;
    locale?: string | undefined;
    value?: any | undefined;
    valueId?: string | undefined;
    valueType?: DynamicPropertyObjectValueValueType;
    propertyId?: string | undefined;
    propertyName?: string | undefined;
    constructor(data?: IDynamicPropertyObjectValue);
    init(_data?: any): void;
    static fromJS(data: any): DynamicPropertyObjectValue;
    toJSON(data?: any): any;
}
export interface IDynamicPropertyObjectValue {
    objectType?: string | undefined;
    objectId?: string | undefined;
    locale?: string | undefined;
    value?: any | undefined;
    valueId?: string | undefined;
    valueType?: DynamicPropertyObjectValueValueType;
    propertyId?: string | undefined;
    propertyName?: string | undefined;
}
export declare enum DynamicPropertyValueType {
    Undefined = "Undefined",
    ShortText = "ShortText",
    LongText = "LongText",
    Integer = "Integer",
    Decimal = "Decimal",
    DateTime = "DateTime",
    Boolean = "Boolean",
    Html = "Html",
    Image = "Image"
}
export declare class FilePublishStatus implements IFilePublishStatus {
    published?: boolean;
    hasChanges?: boolean;
    constructor(data?: IFilePublishStatus);
    init(_data?: any): void;
    static fromJS(data: any): FilePublishStatus;
    toJSON(data?: any): any;
}
export interface IFilePublishStatus {
    published?: boolean;
    hasChanges?: boolean;
}
export declare class GroupedPageBuilderPage implements IGroupedPageBuilderPage {
    storeId?: string | undefined;
    pages?: PageBuilderPage[] | undefined;
    cultureName?: string | undefined;
    name?: string | undefined;
    permalink?: string | undefined;
    organizationId?: string | undefined;
    visibility?: boolean;
    userGroups?: string | undefined;
    startDate?: Date | undefined;
    endDate?: Date | undefined;
    readonly status?: string | undefined;
    readonly hasChanges?: boolean;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: IGroupedPageBuilderPage);
    init(_data?: any): void;
    static fromJS(data: any): GroupedPageBuilderPage;
    toJSON(data?: any): any;
}
export interface IGroupedPageBuilderPage {
    storeId?: string | undefined;
    pages?: PageBuilderPage[] | undefined;
    cultureName?: string | undefined;
    name?: string | undefined;
    permalink?: string | undefined;
    organizationId?: string | undefined;
    visibility?: boolean;
    userGroups?: string | undefined;
    startDate?: Date | undefined;
    endDate?: Date | undefined;
    status?: string | undefined;
    hasChanges?: boolean;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare class GroupedPageBuilderPageSearchResult implements IGroupedPageBuilderPageSearchResult {
    totalCount?: number;
    results?: GroupedPageBuilderPage[] | undefined;
    constructor(data?: IGroupedPageBuilderPageSearchResult);
    init(_data?: any): void;
    static fromJS(data: any): GroupedPageBuilderPageSearchResult;
    toJSON(data?: any): any;
}
export interface IGroupedPageBuilderPageSearchResult {
    totalCount?: number;
    results?: GroupedPageBuilderPage[] | undefined;
}
export declare class Member implements IMember {
    name?: string | undefined;
    memberType?: string | undefined;
    outerId?: string | undefined;
    status?: string | undefined;
    addresses?: CustomerAddress[] | undefined;
    phones?: string[] | undefined;
    emails?: string[] | undefined;
    notes?: Note[] | undefined;
    groups?: string[] | undefined;
    iconUrl?: string | undefined;
    relevanceScore?: number | undefined;
    readonly objectType?: string | undefined;
    dynamicProperties?: DynamicObjectProperty[] | undefined;
    useDynamicPropertyAccessor?: boolean;
    dynamicPropertyAccessor?: any | undefined;
    readonly seoObjectType?: string | undefined;
    seoInfos?: SeoInfo[] | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: IMember);
    init(_data?: any): void;
    static fromJS(data: any): Member;
    toJSON(data?: any): any;
}
export interface IMember {
    name?: string | undefined;
    memberType?: string | undefined;
    outerId?: string | undefined;
    status?: string | undefined;
    addresses?: CustomerAddress[] | undefined;
    phones?: string[] | undefined;
    emails?: string[] | undefined;
    notes?: Note[] | undefined;
    groups?: string[] | undefined;
    iconUrl?: string | undefined;
    relevanceScore?: number | undefined;
    objectType?: string | undefined;
    dynamicProperties?: DynamicObjectProperty[] | undefined;
    useDynamicPropertyAccessor?: boolean;
    dynamicPropertyAccessor?: any | undefined;
    seoObjectType?: string | undefined;
    seoInfos?: SeoInfo[] | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare class MemberSearchResult implements IMemberSearchResult {
    totalCount?: number;
    results?: Member[] | undefined;
    constructor(data?: IMemberSearchResult);
    init(_data?: any): void;
    static fromJS(data: any): MemberSearchResult;
    toJSON(data?: any): any;
}
export interface IMemberSearchResult {
    totalCount?: number;
    results?: Member[] | undefined;
}
export declare class MembersSearchCriteria implements IMembersSearchCriteria {
    memberType?: string | undefined;
    memberTypes?: string[] | undefined;
    group?: string | undefined;
    groups?: string[] | undefined;
    memberId?: string | undefined;
    deepSearch?: boolean;
    outerIds?: string[] | undefined;
    responseGroup?: string | undefined;
    objectType?: string | undefined;
    objectTypes?: string[] | undefined;
    objectIds?: string[] | undefined;
    keyword?: string | undefined;
    searchPhrase?: string | undefined;
    languageCode?: string | undefined;
    sort?: string | undefined;
    readonly sortInfos?: SortInfo[] | undefined;
    skip?: number;
    take?: number;
    constructor(data?: IMembersSearchCriteria);
    init(_data?: any): void;
    static fromJS(data: any): MembersSearchCriteria;
    toJSON(data?: any): any;
}
export interface IMembersSearchCriteria {
    memberType?: string | undefined;
    memberTypes?: string[] | undefined;
    group?: string | undefined;
    groups?: string[] | undefined;
    memberId?: string | undefined;
    deepSearch?: boolean;
    outerIds?: string[] | undefined;
    responseGroup?: string | undefined;
    objectType?: string | undefined;
    objectTypes?: string[] | undefined;
    objectIds?: string[] | undefined;
    keyword?: string | undefined;
    searchPhrase?: string | undefined;
    languageCode?: string | undefined;
    sort?: string | undefined;
    sortInfos?: SortInfo[] | undefined;
    skip?: number;
    take?: number;
}
export declare class Note implements INote {
    title?: string | undefined;
    body?: string | undefined;
    outerId?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: INote);
    init(_data?: any): void;
    static fromJS(data: any): Note;
    toJSON(data?: any): any;
}
export interface INote {
    title?: string | undefined;
    body?: string | undefined;
    outerId?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare class PageBuilderPage implements IPageBuilderPage {
    groupId?: string | undefined;
    storeId?: string | undefined;
    status?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: IPageBuilderPage);
    init(_data?: any): void;
    static fromJS(data: any): PageBuilderPage;
    toJSON(data?: any): any;
}
export interface IPageBuilderPage {
    groupId?: string | undefined;
    storeId?: string | undefined;
    status?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare class PageBuilderPageSearchCriteria implements IPageBuilderPageSearchCriteria {
    storeId?: string | undefined;
    statuses?: string | undefined;
    lifecycle?: string | undefined;
    activeOn?: Date | undefined;
    responseGroup?: string | undefined;
    objectType?: string | undefined;
    objectTypes?: string[] | undefined;
    objectIds?: string[] | undefined;
    keyword?: string | undefined;
    searchPhrase?: string | undefined;
    languageCode?: string | undefined;
    sort?: string | undefined;
    readonly sortInfos?: SortInfo[] | undefined;
    skip?: number;
    take?: number;
    constructor(data?: IPageBuilderPageSearchCriteria);
    init(_data?: any): void;
    static fromJS(data: any): PageBuilderPageSearchCriteria;
    toJSON(data?: any): any;
}
export interface IPageBuilderPageSearchCriteria {
    storeId?: string | undefined;
    statuses?: string | undefined;
    lifecycle?: string | undefined;
    activeOn?: Date | undefined;
    responseGroup?: string | undefined;
    objectType?: string | undefined;
    objectTypes?: string[] | undefined;
    objectIds?: string[] | undefined;
    keyword?: string | undefined;
    searchPhrase?: string | undefined;
    languageCode?: string | undefined;
    sort?: string | undefined;
    sortInfos?: SortInfo[] | undefined;
    skip?: number;
    take?: number;
}
export declare class SaveFilesModel implements ISaveFilesModel {
    files?: string | undefined;
    constructor(data?: ISaveFilesModel);
    init(_data?: any): void;
    static fromJS(data: any): SaveFilesModel;
    toJSON(data?: any): any;
}
export interface ISaveFilesModel {
    files?: string | undefined;
}
export declare class SeoInfo implements ISeoInfo {
    name?: string | undefined;
    semanticUrl?: string | undefined;
    outline?: string | undefined;
    pageTitle?: string | undefined;
    metaDescription?: string | undefined;
    imageAltDescription?: string | undefined;
    metaKeywords?: string | undefined;
    storeId?: string | undefined;
    organizationId?: string | undefined;
    objectId?: string | undefined;
    objectType?: string | undefined;
    isActive?: boolean;
    languageCode?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
    constructor(data?: ISeoInfo);
    init(_data?: any): void;
    static fromJS(data: any): SeoInfo;
    toJSON(data?: any): any;
}
export interface ISeoInfo {
    name?: string | undefined;
    semanticUrl?: string | undefined;
    outline?: string | undefined;
    pageTitle?: string | undefined;
    metaDescription?: string | undefined;
    imageAltDescription?: string | undefined;
    metaKeywords?: string | undefined;
    storeId?: string | undefined;
    organizationId?: string | undefined;
    objectId?: string | undefined;
    objectType?: string | undefined;
    isActive?: boolean;
    languageCode?: string | undefined;
    createdDate?: Date;
    modifiedDate?: Date | undefined;
    createdBy?: string | undefined;
    modifiedBy?: string | undefined;
    id?: string | undefined;
}
export declare enum SortDirection {
    Ascending = "Ascending",
    Descending = "Descending"
}
export declare class SortInfo implements ISortInfo {
    sortColumn?: string | undefined;
    sortDirection?: SortInfoSortDirection;
    constructor(data?: ISortInfo);
    init(_data?: any): void;
    static fromJS(data: any): SortInfo;
    toJSON(data?: any): any;
}
export interface ISortInfo {
    sortColumn?: string | undefined;
    sortDirection?: SortInfoSortDirection;
}
export declare enum CustomerAddressAddressType {
    Undefined = "Undefined",
    Billing = "Billing",
    Shipping = "Shipping",
    BillingAndShipping = "BillingAndShipping",
    Pickup = "Pickup"
}
export declare enum DynamicObjectPropertyValueType {
    Undefined = "Undefined",
    ShortText = "ShortText",
    LongText = "LongText",
    Integer = "Integer",
    Decimal = "Decimal",
    DateTime = "DateTime",
    Boolean = "Boolean",
    Html = "Html",
    Image = "Image"
}
export declare enum DynamicPropertyObjectValueValueType {
    Undefined = "Undefined",
    ShortText = "ShortText",
    LongText = "LongText",
    Integer = "Integer",
    Decimal = "Decimal",
    DateTime = "DateTime",
    Boolean = "Boolean",
    Html = "Html",
    Image = "Image"
}
export declare enum SortInfoSortDirection {
    Ascending = "Ascending",
    Descending = "Descending"
}
export declare class ApiException extends Error {
    message: string;
    status: number;
    response: string;
    headers: {
        [key: string]: any;
    };
    result: any;
    constructor(message: string, status: number, response: string, headers: {
        [key: string]: any;
    }, result: any);
    protected isApiException: boolean;
    static isApiException(obj: any): obj is ApiException;
}
//# sourceMappingURL=virtocommerce.pagebuildermodule.d.ts.map