import { Ref, ComputedRef } from "vue";
import { FilePublishStatus, GroupedPageBuilderPage } from "../../../../api_client/virtocommerce.pagebuildermodule";
import { IUserGroupsResult } from "./../useUserGroups";
import { IOrganizationsResult } from "./../useOrganizations";
export interface IUsePageBuilderDetails {
    item: Ref<GroupedPageBuilderPage>;
    status: Ref<FilePublishStatus>;
    isModified: Readonly<Ref<boolean>>;
    loading: ComputedRef<boolean>;
    loadGroup: () => Promise<void>;
    saveGroup: () => Promise<GroupedPageBuilderPage>;
    deleteGroup: () => Promise<void>;
    loadUserGroups: () => Promise<IUserGroupsResult>;
    loadOrganizations: (keyword?: string, skip?: number, objectIds?: string[]) => Promise<IOrganizationsResult>;
    isReadOnly: ComputedRef<boolean>;
    statusText: ComputedRef<string>;
    publishGroup: () => Promise<void>;
    unpublishGroup: () => Promise<void>;
    openDraftDesigner: () => void;
}
export interface UsePageBuilderDetailsOptions {
    id?: string;
    storeId?: string;
}
export declare function usePageBuilderDetails(options?: UsePageBuilderDetailsOptions): IUsePageBuilderDetails;
//# sourceMappingURL=index.d.ts.map