import { ComputedRef } from "vue";
import { IPageBuilderPageSearchCriteria, GroupedPageBuilderPage } from "../../../../api_client/virtocommerce.pagebuildermodule";
export declare enum PageStatuses {
    Draft = "Draft",
    Published = "Published",
    Archived = "Archived"
}
export declare enum PageLifecycleFilters {
    Draft = "drafts",
    Active = "active",
    Archived = "archived",
    Pending = "pending"
}
export interface IUsePageBuilderList {
    items: ComputedRef<GroupedPageBuilderPage[]>;
    totalCount: ComputedRef<number>;
    pages: ComputedRef<number>;
    currentPage: ComputedRef<number>;
    searchQuery: ComputedRef<IPageBuilderPageSearchCriteria>;
    loadPages: (query?: IPageBuilderPageSearchCriteria) => Promise<void>;
    removePages: (query?: {
        ids: string[];
    }) => Promise<void>;
    loading: ComputedRef<boolean>;
    pageStatuses: ComputedRef<{
        value: string;
        label: string;
    }[]>;
    storeId: ComputedRef<string | null>;
}
export interface UsePageBuilderListOptions {
    pageSize?: number;
    sort?: string;
    statuses?: PageStatuses[];
    lifecycle?: PageLifecycleFilters[];
}
export declare function usePageBuilderList(options?: UsePageBuilderListOptions): IUsePageBuilderList;
//# sourceMappingURL=index.d.ts.map